% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/green_space_clustering.R
\name{green_space_clustering}
\alias{green_space_clustering}
\title{Green Space Clustering with K-Means and Tile Layer Control in Leaflet}
\usage{
green_space_clustering(green_areas_data, num_clusters)
}
\arguments{
\item{green_areas_data}{List containing green areas data (obtained from get_osm_data function or similar).}

\item{num_clusters}{Integer number of clusters to divide the green spaces into.}
}
\value{
A Leaflet map object displaying clustered green spaces with layer control for basemap tiles.
}
\description{
This function performs K-means clustering on green spaces based on their area size and visualizes the results on a Leaflet map.
Users must specify the number of clusters. The function includes a layer control for switching between different basemap tiles.
}
\examples{
\donttest{
  # Create example green_areas_data
  library(sf)
  green_areas <- st_sf(
    id = 1:5,
    geometry = st_sfc(
      st_polygon(list(rbind(c(0, 0), c(0, 1), c(1, 1), c(1, 0), c(0, 0)))),
      st_polygon(list(rbind(c(1, 1), c(1, 2), c(2, 2), c(2, 1), c(1, 1)))),
      st_polygon(list(rbind(c(2, 2), c(2, 3), c(3, 3), c(3, 2), c(2, 2)))),
      st_polygon(list(rbind(c(3, 3), c(3, 4), c(4, 4), c(4, 3), c(3, 3)))),
      st_polygon(list(rbind(c(4, 4), c(4, 5), c(5, 5), c(5, 4), c(4, 4))))
    ),
    crs = 4326  # Assign a CRS (WGS 84)
  )
  green_areas_data <- list(osm_polygons = green_areas)
  # Run the clustering function
  map <- green_space_clustering(green_areas_data, num_clusters = 2)
  map # to display the map
}
}
