% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{samplers}
\alias{samplers}
\alias{hmc}
\alias{rwmh}
\alias{slice}
\title{MCMC samplers}
\usage{
hmc(Lmin = 5, Lmax = 10, epsilon = 0.1, diag_sd = 1)

rwmh(proposal = c("normal", "uniform"), epsilon = 0.1, diag_sd = 1)

slice(max_doublings = 5)
}
\arguments{
\item{Lmin}{minimum number of leapfrog steps (positive integer, Lmin > Lmax)}

\item{Lmax}{maximum number of leapfrog steps (positive integer, Lmax > Lmin)}

\item{epsilon}{leapfrog stepsize hyperparameter (positive, will be tuned)}

\item{diag_sd}{estimate of the posterior marginal standard deviations
(positive, will be tuned).}

\item{proposal}{the probability distribution used to generate proposal states}

\item{max_doublings}{the maximum number of iterations of the 'doubling'
algorithm used to adapt the size of the slice}
}
\value{
a \code{sampler} object that can be passed to \code{\link[=mcmc]{mcmc()}}.
}
\description{
Functions to set up MCMC samplers and change the starting values
of their parameters, for use in \code{\link[=mcmc]{mcmc()}}.
}
\details{
During the warmup iterations of \code{mcmc}, some of these
sampler parameters will be tuned to improve the efficiency of the sampler,
so the values provided here are used as starting values.

For \code{hmc()}, the number of leapfrog steps at each iteration is
selected uniformly at random from between \code{Lmin} and \code{Lmax}.
\code{diag_sd} is used to rescale the parameter space to make it more
uniform, and make sampling more efficient.

\code{rwmh()} creates a random walk Metropolis-Hastings sampler;  a
a gradient-free sampling algorithm. The algorithm involves a proposal
generating step \code{proposal_state = current_state + perturb} by a random
perturbation, followed by Metropolis-Hastings accept/reject step. The class
is implemented for uniform and normal proposals.

\code{slice()} implements a multivariate slice sampling algorithm.
The parameter \code{max_doublings} is not tuned during warmup.
}
