% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{AICc}
\alias{AICc}
\alias{BICc}
\title{Corrected Akaike's Information Criterion and Bayesian Information Criterion}
\usage{
AICc(object, ...)

BICc(object, ...)
}
\arguments{
\item{object}{Time series model.}

\item{...}{Some stuff.}
}
\value{
This function returns numeric value.
}
\description{
This function extracts AICc / BICc from models. It can be applied to wide
variety of models that use logLik() and nobs() methods (including the
popular lm, forecast, smooth classes).
}
\details{
AICc was proposed by Nariaki Sugiura in 1978 and is used on small samples
for the models with normally distributed residuals. BICc was derived in
McQuarrie (1999) and is used in similar circumstances.

IMPORTANT NOTE: both of the criteria can only be used for univariate models
(regression models, ARIMA, ETS etc) with normally distributed residuals!
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")

ourModel <- stepwise(xreg)

AICc(ourModel,h=10)
BICc(ourModel,h=10)

}
\references{
\itemize{
\item Burnham Kenneth P. and Anderson David R. (2002). Model Selection
and Multimodel Inference. A Practical Information-Theoretic Approach.
Springer-Verlag New York. DOI: [10.1007/b97636](http://dx.doi.org/10.1007/b97636).
}

\itemize{
\item McQuarrie A.D., A small-sample correction for the Schwarz SIC
model selection criterion, Statistics & Probability Letters 44 (1999)
pp.79-86. \doi{10.1016/S0167-7152(98)00294-6}
\item Sugiura Nariaki (1978) Further analysts of the data by Akaike's
information criterion and the finite corrections, Communications in
Statistics - Theory and Methods, 7:1, 13-26,
\doi{10.1080/03610927808827599}
}
}
\seealso{
\link[stats]{AIC}, \link[stats]{BIC}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
