% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphmaker.R
\name{graphmaker}
\alias{graphmaker}
\title{Linear graph construction function}
\usage{
graphmaker(actuals, forecast, fitted = NULL, lower = NULL,
  upper = NULL, level = NULL, legend = TRUE, cumulative = FALSE,
  vline = TRUE, parReset = TRUE, ...)
}
\arguments{
\item{actuals}{The vector of actual values}

\item{forecast}{The vector of forecasts. Should be \code{ts} object that starts at
the end of \code{fitted} values.}

\item{fitted}{The vector of fitted values.}

\item{lower}{The vector of lower bound values of a prediction interval.
Should be ts object that start at the end of \code{fitted} values.}

\item{upper}{The vector of upper bound values of a prediction interval.
Should be ts object that start at the end of \code{fitted} values.}

\item{level}{The width of the prediction interval.}

\item{legend}{If \code{TRUE}, the legend is drawn.}

\item{cumulative}{If \code{TRUE}, then the forecast is treated as
cumulative and value per period is plotted.}

\item{vline}{Whether to draw the vertical line, splitting the in-sample
and the holdout sample.}

\item{parReset}{Whether to reset par() after plotting things or not.
If \code{FALSE} then you can add elements to the plot (e.g. additional lines).}

\item{...}{Other parameters passed to \code{plot()} function.}
}
\value{
Function does not return anything.
}
\description{
The function makes a standard linear graph using the provided actuals and
forecasts.
}
\details{
Function uses the provided data to construct a linear graph. It is strongly
advised to use \code{ts} objects to define the start of each of the vectors.
Otherwise the data may be plotted incorrectly.
}
\examples{

x <- rnorm(100,0,1)
values <- forecast(arima(x),h=10,level=0.95)

graphmaker(x,values$mean,fitted(values))
graphmaker(x,values$mean,fitted(values),legend=FALSE)
graphmaker(x,values$mean,fitted(values),values$lower,values$upper,level=0.95)
graphmaker(x,values$mean,fitted(values),values$lower,values$upper,level=0.95,legend=FALSE)

# Produce the necessary ts objects from an arbitrary vectors
actuals <- ts(c(1:10), start=c(2000,1), frequency=4)
forecast <- ts(c(11:15),start=end(actuals)[1]+end(actuals)[2]*deltat(actuals),
               frequency=frequency(actuals))
graphmaker(actuals,forecast)

# This should work as well
graphmaker(c(1:10),c(11:15))

# This way you can add additional elements to the plot
graphmaker(c(1:10),c(11:15), parReset=FALSE)
points(c(1:15))
# But don't forget to do dev.off() in order to reset the plotting area afterwards

}
\seealso{
\code{\link[stats]{ts}}
}
\author{
Ivan Svetunkov
}
\keyword{graph}
\keyword{linear}
\keyword{plots}
