# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' This function calculates parameters for the polynomials
#'
#' The function accepts two vectors with the parameters for the polynomials and returns
#' the vector of parameters after their multiplication. This can be especially useful,
#' when working with ARIMA models.
#'
#' @param x The vector of parameters of the first polynomial.
#' @param y The vector of parameters of the second polynomial.
#'
#' @template author
#'
#' @return The function returns a matrix with one column with the parameters for
#' the polynomial, starting from the 0-order.
#'
#' @seealso \link[stats]{convolve}
#'
#' @examples
#'
#' polyprod(c(1,-2,-1),c(1,0.5,0.3))
#'
#' @useDynLib greybox
#' @export
polyprod <- function(x, y) {
    .Call('_greybox_polyprod', PACKAGE = 'greybox', x, y)
}

