% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pointLik}
\alias{pointLik}
\title{Point likelihood values}
\usage{
pointLik(object, ...)
}
\arguments{
\item{object}{Time series model.}

\item{...}{Some stuff.}
}
\value{
This function returns a vector.
}
\description{
This function returns a vector of logarithms of likelihoods for each observation
}
\details{
Instead of taking the expected log-likelihood for the whole series, this function
calculates the individual value for each separate observation. Note that these
values are biased, so you would possibly need to take number of degrees of freedom
into account in order to have an unbiased estimator.

This value is based on the general likelihood (not its concentrated version), so
the sum of these values may slightly differ from the output of logLik.
}
\examples{

xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
ourModel <- alm(y~x1+x2,as.data.frame(xreg))

pointLik(ourModel)

# Bias correction
pointLik(ourModel) - nparam(ourModel)

# Bias correction in AIC style
2*(nparam(ourModel)/nobs(ourModel) - pointLik(ourModel))

# BIC calculation based on pointLik
log(nobs(ourModel))*nparam(ourModel) - 2*sum(pointLik(ourModel))

}
\seealso{
\link[stats]{AIC}, \link[stats]{BIC}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
