% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_win_prob_vs_baseline_given_posterior.R
\name{estimate_win_prob_vs_baseline_given_posterior}
\alias{estimate_win_prob_vs_baseline_given_posterior}
\title{Estimate Win Probability vs. Baseline Given Posterior}
\usage{
estimate_win_prob_vs_baseline_given_posterior(
  posterior_samples,
  distribution,
  wrt_option
)
}
\arguments{
\item{posterior_samples}{Tibble returned from sample_from_posterior with 3 columns
`option_name`, `samples`, and `sample_id`.}

\item{distribution}{String: the distribution name}

\item{wrt_option}{String: the option to compare against the best option.}
}
\value{
Tibble of each option_name and the win probability expressed as a percentage and a decimal `raw`
}
\description{
Calculates the win probability of the best option compared to a single other option
given a posterior distribution.
}
\examples{
# Requires posterior_samples dataframe. See `sample_from_posterior()`
# for an example.
\dontrun{
estimate_win_prob_vs_baseline_given_posterior(
    posterior_samples = posterior_samples,
    distribution = "conversion_rate",
    wrt_option = "A")
}

}
