% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to.R
\name{convert_to_grob}
\alias{convert_to_grob}
\title{Takes in an object, and converts it to a grob based on inputted aesthetics arguments.}
\usage{
convert_to_grob(x, height, width, aes_list = ga_list())
}
\arguments{
\item{x}{The object which needs to be converted to a grob. Must be either: 
A data.frame/matrix, the file name of a .png image, a character string, a 
vector, a ggplot object, or \code{NA} (for an empty grob).}

\item{height}{The numeric height in mm of the desired grob.}

\item{width}{The numeric width in mm of the desired grob.}

\item{aes_list}{The list outputted by \code{ga_list} which contains elements 
to adjust aesthetics to the grob of \code{x}. Different type of grobs have
different types of elements of this list which will affect its aesthetics.

Possible elements for character strings, matrices and images can be found in \code{\link{ga_list}}.}
}
\value{
A grob of x with aesthetics based on the aes_list parameter.
}
\description{
Takes in an object, and converts it to a grob based on inputted aesthetics arguments.
}
