% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groundhog.library.R
\name{groundhog.library}
\alias{groundhog.library}
\title{Install & load CRAN, GitHub, and GitLab packages as current on given date}
\usage{
groundhog.library(
  pkg,
  date,
  quiet.install = TRUE,
  include.suggests = FALSE,
  ignore.deps = c(),
  force.source = FALSE,
  force.install = FALSE,
  tolerate.R.version = ""
)
}
\arguments{
\item{pkg}{character string or vector with name of target package(s).
Single package names need not be in quotes.}

\item{date}{character string  (yyyy-mm-dd), or date value, with the date which
determines the version of the package, and all dependencies, to be loaded
(and installed if needed). #'The most recent #'date accepted is 2 days prior
to when the code is executed.}

\item{quiet.install}{logical, defaults to \code{TRUE}. When set to \code{FALSE}, displays
output generated by \code{install.packages()} when installing from source}

\item{include.suggests}{logical, defaults to \code{FALSE}. When set to \code{TRUE},
loads dependencies classified in the DESCRIPTION file as \code{suggested}.}

\item{ignore.deps}{an optional character vector containing dependencies which
may be already loaded in the R session and even if the loaded version does
not match the version implied by the entered date, groundhog.library() will
proceed and ignore #'   this conflict. If one version of a package is loaded,
and a different is needed for #'   groundhog, the default behavior is to
stop the request and ask the user to restart #'   the R session to unload
all packages. This will bypass that requirement.}

\item{force.source}{logical (defaults to \code{FALSE}). When set to \code{TRUE}, will
not attempt installing binary from CRAN or MRAN and instead download source
file and install it.}

\item{force.install}{logical (defaults to \code{FALSE}). When set to \code{TRUE}, will}

\item{tolerate.R.version}{optional character string containing an R version
which \code{groundhog.library()} will not throw an error for using, even if the
date entered corresponds to a more recent major R release.}
}
\value{
a character vector containing all active packages for the session,
with their version number, under the format \code{pkg_vrs}.
}
\description{
Groundhog maintains a separate local package library where it stores
version-controlled packages, with multiple versions of the same package saved
side-by-side. The \code{date} argument in the \code{groundhog.library()} function
determines the version of the package that is loaded (the most recently
available version on that date). #' If that version of the package is not
already installed in the local \code{groundhog} library, #' it is automatically
installed. \code{groundhog.library()} thus substitutes both \code{library()} and
\code{install.packages()}. No changes to how R manages packages are made
(e.g., no change to  #' .libPaths(), to .Rprofile, or to R Studio global
settings). Therefore, to discontinue relying on \code{groundhog}, all you do is go
back to #' executing the \code{install.packages()} and \code{library()} #' functions,
instead of the \code{groundhog.library()} function.
}
\details{
For more information about groundhog check out \href{http://groundhogr.com}{groundhogr.com}
}
\examples{
\dontrun{
groundhog.library("magrittr", "2022-04-01")

pkgs <- c('pwr','metafor')
groundhog.library(pkgs, "2022-04-01")

# When running an existing  script that relied on `library()` to load packages,
# you can wrap the library calls in double-quotes, loading the packages with 
# groundhog:

  groundhog.library(
       "
        library('pwr')
        library('metafor')
        library('tidyr')
        library('rio')
        library('this.path')
       "
       ,'2022-04-01')

#Allow using R 3.6.3 despite entering a date that corresponds to R >=4.0.0
  groundhog.library('rio', '2022-04-11', tolerate.R.version='3.6.3')

}

}
