% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_proptest.R
\name{grouped_proptest}
\alias{grouped_proptest}
\title{Function to run proportion test on grouped data.}
\usage{
grouped_proptest(data, grouping.vars, measure)
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{measure}{A variable for which proportion test needs to be carried out
for each combination of levels of factors entered in \code{grouping.vars}.}
}
\value{
Dataframe with percentages and statistical details from a proportion
test.
}
\description{
Function to run proportion test on grouped data.
}
\examples{
# for reproducibility
set.seed(123)

groupedstats::grouped_proptest(
  data = mtcars,
  grouping.vars = cyl,
  measure = am
)
}
\author{
Indrajeet Patil
}
