% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{fT}
\alias{fT}
\title{Temperature limitation}
\usage{
fT(t, T0 = 4, T1 = 10, T2 = 20)
}
\arguments{
\item{t}{float Temperature in degree Celsius.}

\item{T0}{float Photosynthesis activation temperature in degree Celsius.}

\item{T1}{float Photosynthesis plateau temperature in degree Celsius.}

\item{T2}{float Photosynthesis max temperature in degree Celsius.}
}
\value{
A value in the range (0, 1), acting as a multiplicative factor to
plant growth.
}
\description{
Threshold function representing growth limitation by temperature.
}
\details{
Photosynthesis is suppressed below \emph{T0}, increases until it reaches its
maximum at temperatures in the interval (T1, T2). For temperatures exceeding
\emph{T2}, photosynthetic activity decreases again until it reaches 0 at a
final temperature of 40 degree Celsius.
}
\examples{
fT(4)
fT(10)
fT(15)

}
