% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{get_expected_n_cuts}
\alias{get_expected_n_cuts}
\title{Get number of expected cuts}
\usage{
get_expected_n_cuts(elevation, intensity = "high")
}
\arguments{
\item{elevation}{The elevation of the considered site in meters above sea
level.}

\item{intensity}{One of ("high", "middle", "low", "extensive"). Management
intensity for considered site.}
}
\value{
Number of expected cuts per season.
}
\description{
Return the number of expected cuts for a site at a given \emph{elevation} and
management \emph{intensity}.
}
\details{
This uses data.frame \code{management_parameters} as a lookup table and
interpolates linearly in between the specified values.
}
\examples{
get_expected_n_cuts(1200)
get_expected_n_cuts(1200, intensity = "low")

}
