\name{growthCurve}
\alias{growthCurve}
\title{Within subject model-predicted growth curve}
\usage{
  growthCurve(y.case, B, Alpha, Beta, U = NULL,
    aff.clients = NULL, W.subj = NULL, X.n = NULL,
    Z.n = NULL, trt.case, trt.lab, subject.case,
    subject.lab, T, min.T, max.T, n.thin, n.waves = NULL,
    time.case, n.fix_degree, Nrandom = NULL)
}
\arguments{
  \item{y.case}{The \code{N x 1} (subject-time case) vector
  of data response values.}

  \item{B}{The \code{M x P*q} matrix of subject random
  effect posterior samples.  \code{M} = number of MCMC
  samples, \code{P} = number of subjects, \code{q} = number
  of random effect parameters, per subject.}

  \item{Alpha}{The \code{M x 1} vector for the model
  intercept parameter.}

  \item{Beta}{The \code{M x F} matrix of model fixed
  effects parameters, where \code{F} = number of fixed
  effects}

  \item{U}{The \code{M x S} matrix of multiple membership
  random effects, where \code{S} = number of random
  effects.  Leave \code{NULL} is don't require the multiple
  membership effects.  Input as list of \code{M x S}
  matrices if have more than one mutiple membership term.}

  \item{aff.clients}{Vector of length \code{P.aff} that
  identifies subjects affected by \code{U}.  Identical to
  \code{subj.aff} from \code{\link{dpgrowmm}}.  Input as
  list of vectors, each comprised of affected subjects
  attached to the equivalent multiple membership term if
  have more than one term.}

  \item{W.subj}{A \code{P x S} multiple membership weight
  matrix for \code{U} that expands \code{W.subj.aff} of
  \code{\link{dpgrowmm}} from affected subjects,
  \code{Paff} to all subjects, \code{P}.  Input as list of
  \code{P[i] x S[i]} matrices, where i indexes an MM term,
  if have more than one multiple membership term.}

  \item{X.n}{A design matrix with \code{N} rows (for
  subject-measure) cases providing nuisance fixed effects.
  Will be expanded to the \code{T} within sample
  predictions, but held constant between successive
  observed values (for generating expanded predictions).}

  \item{Z.n}{A design matrix with \code{N} rows providing
  nuisance random effects.  Grouping is assumed to be
  by-subject.}

  \item{trt.case}{The treatment group membership vector of
  length \code{N} (subject-time cases).  Assumed numeric
  with lowest group level == 0; .e.g.
  \code{(0,0,0,1,1,2,2,2,2,)}.}

  \item{trt.lab}{Associated labels for the numeric
  treatment groups.  Each distinct treatment group assumed
  to have a unique label.}

  \item{subject.case}{Vector of length \code{N} providing
  subject-measure cases.  Must be in numerical format with
  unique subjects sequential starting at 1.}

  \item{subject.lab}{\code{N x 1} case length vector with
  user desired labels that map 1:1 to \code{subject.case}.}

  \item{T}{Number of time points to build each subject
  curve.  \code{T = 10} is typically sufficient.}

  \item{min.T}{The minimum time value that \code{T} will
  take.}

  \item{max.T}{The maximum time value that \code{T} will
  take.}

  \item{n.thin}{The gap between each MCMC sample used for
  the growth curve.}

  \item{n.waves}{The maximum number of observed measurement
  waves, per subject.}

  \item{time.case}{A vector of length \code{N} providing
  times for associated subject-measure observations.
  Identical to \code{time} from \code{\link{dpgrowmm}}.}

  \item{n.fix_degree}{The highest polynomial degree to
  employ for constructing time-based fixed effects
  covariates.}

  \item{Nrandom}{A scalar input providing the number of
  by-subject time-based random effect parameters. Only need
  to input if employ nuisance random effects.}
}
\value{
  A list object containing the following \code{data.frames}
  and plots: \item{plot.dat}{A \code{data.frame} object
  containing the within-subjects predicted growth curves.
  Fields are titled,
  \code{c("fit","time","subject","trt")}.}
  \item{dat.data}{A \code{data.frame} object containing
  actual by-subject data for each measurement occasion.
  Fields are titled,
  \code{c("fit","time","subject","trt")}.} \item{p.gcall}{A
  \code{ggplot2} object that aggregates growth curves by
  treatment type.} \item{p.gcsel}{A \code{ggplot2} object
  that plots growth curves with associated data points for
  10 randomly selected subjects.}
}
\description{
  Produces a set of predicted response values, by subject,
  at \code{T} time points.  The response values are
  predicted by employing the posterior samples of model
  parameters where the resultant response values for each
  subject are composed by averaging over all posterior
  samples in a Rao-Blackwellizing fashion.
}
\note{
  Intended as an internal function for
  \code{\link{dpgrow}}, \code{\link{dpgrowmm}}, and
  \code{\link{dpgrowmult}}
}
\author{
  Terrance Savitsky \email{tds151@gmail.com}
}
\seealso{
  \code{\link{dpgrowmm}}, \code{\link{dpgrow}},
  \code{\link{dpgrowmult}}
}

