% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpslope.R
\name{proxGroupSortedL1}
\alias{proxGroupSortedL1}
\title{Prox for group SLOPE}
\usage{
proxGroupSortedL1(y, group, lambda, method = "rcpp")
}
\arguments{
\item{y}{The response vector}

\item{group}{A vector or an object of class \code{groupID} (e.g. as produced by 
\code{\link{getGroups}}), which is describing the grouping structure. If it is
a vector, then it should contain a group id for each predictor variable.}

\item{lambda}{A decreasing sequence of regularization parameters \eqn{\lambda}}

\item{method}{Specifies which implementation of the Sorted L1 norm prox should be used. 
Possible values are \code{"rcpp"} (default), \code{"c"}, and \code{"isotone"}. See detail.}
}
\description{
Evaluate the proximal mapping for the group SLOPE problem.
}
\details{
\code{proxGroupSortedL1} evaluates the proximal mapping of the group SLOPE problem
by reducing it to the prox for the (regular) SLOPE and then applying the fast prox
algorithm for the Sorted L1 norm. The argument \code{method} specifies which 
implementation of the Sorted L1 norm prox should be used. 
Possible values are \code{"rcpp"} (default), \code{"c"}, and \code{"isotone"}.
The default option \code{"rcpp"} uses the internal implementation in
\code{\link{proxSortedL1}}. The alternative options \code{"c"} and
\code{"isotone"} call the function \code{\link[SLOPE]{prox_sorted_L1}} from the
package \code{SLOPE} (see there for detail on these two options).
}
\examples{
grp <- c(0,0,0,1,1,0,2,1,0,2)
proxGroupSortedL1(y = 1:10, group = grp, lambda = 10:1)
#  [1] 0.2032270 0.4064540 0.6096810 0.8771198 1.0963997 1.2193620 1.3338960
#  [8] 1.7542395 1.8290430 1.9055657

}
\references{
M. Bogdan, E. van den Berg, C. Sabatti, W. Su, E. Candes (2015), \emph{SLOPE -- Adaptive variable selection via convex optimization}, \url{http://arxiv.org/abs/1407.3824}
}

