% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_validation.R
\name{crossval}
\alias{crossval}
\title{Parameter selection by crossvalidation}
\usage{
crossval(
  A,
  epsilon = 0.1,
  nb.boot = 5,
  thresh = 1e-05,
  maxit = 100,
  lambda1.max = NULL,
  lambda2.max = NULL,
  lambda1.min = NULL,
  lambda2.min = NULL,
  length = 10,
  S0 = NULL,
  L0 = NULL,
  trace.it = FALSE
)
}
\arguments{
\item{A}{nxn adjacency matrix}

\item{epsilon}{regularization parameter for the L^2-norm penalty (positive number, if NULL, default method is applied)}

\item{nb.boot}{number of folds for cross validation (integer)}

\item{thresh}{convergence tolerance (positive number)}

\item{maxit}{maximum number of iterations (positive integer)}

\item{lambda1.max}{maximum regularization parameter for nuclear norm penalty (positive number)}

\item{lambda2.max}{maximum regularization parameter for 2,1-norm norm penalty (positive number)}

\item{lambda1.min}{minimum regularization parameter for nuclear norm penalty (positive number)}

\item{lambda2.min}{minimum regularization parameter for 2,1-norm norm penalty (positive number)}

\item{length}{size of cross-validation grid (integer)}

\item{S0}{initial value for the sparse component}

\item{L0}{initial value for the low-rank component}

\item{trace.it}{whether messages about convergence should be printed (boolean)}
}
\value{
The values selected by cross-validation for the regularization parameters lambda1 and lambda2.
The return value is a list of components
  \itemize{
  \item{\code{lambda1}}{ selected value for the parameter of the nuclear norm penalization.}
  \item{\code{lambda2}}{ selected value for the parameter of the 2,1-norm penalisation.}
  \item{\code{estim.cv}}{ result of the gsbm_mcgd function for the parameters selected.}
  \item{\code{error}}{ a table containing the errors for all pairs of parameters on the grid.}
  \item{\code{lambda1.grid}}{ grid of value for the parameter lambda1.}
  \item{\code{lambda2.grid}}{ grid of value for the parameter lambda2.}
 }
}
\description{
Selection by cross validation of the regularization parameters (lambda1 and lambda2) for estimating the probabilties of connection in a Generalized Stochastic Block Model.
}
\examples{
# Draw a 50x50 adjacency matrix
# Generalized SBM with 2 communities and 2 outliers
# Create low-rank matrix L
L <- matrix(0,50,50) # low-rank component
L[1:25, 1:25] <- 0.6 # connection probabilities within community 1
L[1:25, 26:48] <- 0.1 # connection probabilities between communities 1 and 2
L[26:48, 1:25] <- 0.1 # connection probabilities between communities 1 and 2
L[26:48, 26:48] <- 0.6 # connection probabilities within community 2

# Create column-sparse matrix S
S <- matrix(0,50,50) # column sparse component
S[49:50,1:48] <- 0.6 # connection probabilities between outliers and inliers

# Draw connections and create the adjacency matrix
undir <- rbinom(n=50*(50-1)/2, size=1, prob=(L+S+t(S))[upper.tri(L+S+t(S))]) # draw edges
A <- matrix(0,50,50)
A[upper.tri(A)] <- undir
A <- (A+t(A))
}
