% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movingrms.R
\name{movingrms}
\alias{movingrms}
\title{Moving Root Mean Square}
\usage{
movingrms(x, width = 0.1, rc = 0.001, fs = 1)
}
\arguments{
\item{x}{Input signal, specified as a numeric vector or matrix. In case of a
matrix, the function operates along the columns}

\item{width}{width of the sigmoid window, in units relative to \code{fs}.
Default: 0.1}

\item{rc}{Rise time (time constant) of the sigmoid window, in units relative
to \code{fs}. Default: 1e-3}

\item{fs}{Sampling frequency. Default: 1}
}
\value{
A \code{\link{list}} containing 2 variables:
\describe{
  \item{rmsx}{Output signal with the same dimensions as \code{x}}
  \item{w}{Window, returned as a vector}
}
}
\description{
Compute the moving root mean square (RMS) of the input signal.
}
\details{
The signal is convoluted against a sigmoid window of width \code{w} and
risetime \code{rc}. The units of these parameters are relative to the value
of the sampling frequency given in \code{fs}.
}
\examples{
N <- 128
t <- seq(0, 1, length.out = N)
x <- sigmoid_train(t, c(0.4, Inf), 1e-2)$y * (2 * runif(length(t)) - 1)
fs <- 1 / diff(t[1:2])
width <- 0.05
rc <- 5e-3
ret <- movingrms(as.numeric(scale(x)), width, rc, fs)
plot(t, x, type = "l", col = "red", xlab = "", ylab = "")
lines(t, ret$rmsx, lwd = 4, col = "black")
polygon(c(0, t, length(t)), c(0, ret$rmsx, 0), col = "blue")
lines (t, ret$w, lwd = 2, col = "green")
legend("topleft", c("data", "window", "movingrms"), lty = 1,
       col = c("red", "green", "blue"))

}
\seealso{
\code{\link{sigmoid_train}}
}
\author{
Juan Pablo Carbajal, \email{carbajal@ifi.uzh.ch}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
