% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheb1ap.R
\name{cheb1ap}
\alias{cheb1ap}
\title{Chebyshev Type I filter prototype}
\usage{
cheb1ap(n, Rp)
}
\arguments{
\item{n}{Order of the filter.}

\item{Rp}{dB of pass-band ripple.}
}
\value{
List of class \code{\link{Zpg}} containing the poles and gain of the
  filter.
}
\description{
Return the poles and gain of an analog Chebyshev Type I lowpass filter
prototype.
}
\details{
This function exists for compatibility with 'Matlab' and 'OCtave' only, and
is equivalent to \code{cheby1(n, Rp, 1, "low", "s")}.
}
\examples{
## 9th order Chebyshev type I low-pass analog filter
zp <- cheb1ap(9, .1)
w <- seq(0, 4, length.out = 128)
freqs(zp, w)

}
\author{
Carne Draug, \email{carandraug+dev@gmail.com}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
