% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwt.R
\name{dwt}
\alias{dwt}
\alias{wfilters}
\title{1-D Discrete Wavelet Transform}
\usage{
dwt(x, wname = "d8", lo = NULL, hi = NULL)

wfilters(wname)
}
\arguments{
\item{x}{input data, specified as a numeric vector.}

\item{wname}{analyzing wavelet, specified as a character string consisting of
a class name followed by the wavelet length Only two classes of wavelets
are supported; Daubechies (denoted by the prefix \code{'d'} of even
lengths 2 - 20, and Coiflet (denoted by the prefix '\code{'c'} of
lengths 6, 12, 18, 24, and 30. The wavelet name \code{'haar'} is
the equivalent of \code{'d2'}. Default: d8.}

\item{lo}{scaling (low-pass) filter, specified as an even-length numeric
vector. \code{lo} must be the same length as \code{hi}. Ignored when
\code{wname != NULL}.}

\item{hi}{wavelet (high-pass) filter, specified as an even-length numeric
vector. \code{hi} must be the same length as \code{lo}, Ignored when
\code{wname != NULL}.}
}
\value{
A list containing two numeric vectors:
\describe{
  \item{a}{approximation (average) coefficients, obtained from convolving
    \code{x} with the scaling (low-pass) filter \code{lo}, and then
    downsampled (keep the even-indexed elements).}
  \item{d}{detail (difference) coefficients, obtained from convolving
    \code{x} with the wavelet (high-pass) filter \code{hi}, and then
    downsampled (keep the even-indexed elements).}
}
}
\description{
Compute the single-level discrete wavelet transform of a signal
}
\details{
This function is only included because of compatibility with the 'Octave'
'signal' package. Specialized packages exist in R to perform the discrete
wavelet transform, e.g., the \code{wavelets} package [1]. this function
recognizes only a few wavelet names, namely those for which scale
coefficients are available (Daubechies [2] and Coiflet [3]).

The wavelet and scaling coefficients are returned by the function
\code{wfilters}, which returns the coefficients for reconstruction filters
associated with the wavelet \code{wname}. Decomposition filters are the time
reverse of the reconstruction filters (see examples).
}
\note{
The notations \code{g} and \code{h} are often used to denote low-pass
  (scaling) and high-pass (wavelet) coefficients, respectively, but
  inconsistently. Ref [4] uses it, as does the R \code{wavelets} package.
  'Octave' uses the reverse notation. To avoid confusion, more neutral terms
  are used here.

There are two naming schemes for wavelet names in use. For instance for
  Daubechies wavelets (d), dN using the length or number of taps, and dbA
  referring to the number of vanishing moments. So d4 and db2 are the same
  wavelet transform. This function uses the formed (dN) notation; 'Matlab'
  uses the latter (dbA).
}
\examples{
# get Coiflet 30 coefficients
wv <- wfilters('c30')
lo <- rev(wv$lo)
hi <- rev(wv$hi)

# general time-varying signal
time <- 1
fs <- 1000
x <- seq(0,time, length.out=time*fs)
y <- c(cos(2*pi*100*x)[1:300], cos(2*pi*50*x)[1:300],
       cos(2*pi*25*x)[1:200], cos(2*pi*10*x)[1:200])
op <- par(mfrow = c(3,1))
plot(x, y, type = "l", xlab = "Time", ylab = "Amplitude",
     main = "Original signal")
wt <- dwt(y, wname = NULL, lo, hi)

x2 <- seq(1, length(x) - length(hi) + 1, 2)
plot(x2, wt$a, type = "h", xlab = "Time", ylab = "",
    main = "Approximation coefficients")
plot(x2, wt$d, type = "h", xlab = "Time", ylab = "",
     main = "Detail coefficients")
par (op)

}
\references{
[1] \url{https://CRAN.R-project.org/package=wavelets}

[2] \url{https://en.wikipedia.org/wiki/Daubechies_wavelet}

[3] \url{https://en.wikipedia.org/wiki/Coiflet}

[4]
  \url{https://en.wikipedia.org/wiki/Discrete_wavelet_transform}
}
\author{
Lukas F. Reichlin.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
