% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bilinear.R
\name{bilinear}
\alias{bilinear}
\alias{bilinear.Zpg}
\alias{bilinear.Arma}
\alias{bilinear.default}
\title{Bilinear transformation}
\usage{
bilinear(Sz, ...)

\method{bilinear}{Zpg}(Sz, T = 2 * tan(1/2), ...)

\method{bilinear}{Arma}(Sz, T = 2 * tan(1/2), ...)

\method{bilinear}{default}(Sz, Sp, Sg, T = 2 * tan(1/2), ...)
}
\arguments{
\item{Sz}{In the generic case, a model to be transformed. In the default
case, a vector containing the zeros in a pole-zero-gain model.}

\item{...}{arguments passed to the generic function.}

\item{T}{the sampling frequency represented in the z plane. Default:
\code{2 * tan(1 / 2)}.}

\item{Sp}{a vector containing the poles in a pole-zero-gain model.}

\item{Sg}{a vector containing the gain in a pole-zero-gain model.}
}
\value{
For the default case or for bilinear.Zpg, an object of class
  \code{'Zpg'}, containing the list elements:
\describe{
  \item{z}{complex vector of the zeros of the transformed model}
  \item{p}{complex vector of the poles of the transformed model}
  \item{g}{gain of the transformed model}
}
For bilinear.Arma, an object of class \code{'Arma'}, containing the list
elements:
\describe{
  \item{b}{moving average (MA) polynomial coefficients}
  \item{a}{autoregressive (AR) polynomial coefficients}
}
}
\description{
Transform a s-plane (analog) filter specification into a z-plane (digital)
specification.
}
\details{
Given a piecewise flat filter design, you can transform it from the s-plane
to the z-plane while maintaining the band edges by means of the bilinear
transform. This maps the left hand side of the s-plane into the interior of
the unit circle. The mapping is highly non-linear, so you must design your
filter with band edges in the s-plane positioned at \eqn{2/T tan(wT / 2)} so
that they will be positioned at \code{w} after the bilinear transform is
complete.

The bilinear transform is:
\deqn{z = (1 + sT / 2) / (1 - sT / 2)}
\deqn{s = (T / 2) (z - 1) / (z + 1)}

Please note that a pole and a zero at the same place exactly cancel. This is
significant since the bilinear transform creates numerous extra poles and
zeros, most of which cancel. Those which do not cancel have a “fill-in”
effect, extending the shorter of the sets to have the same number of as the
longer of the sets of poles and zeros (or at least split the difference in
the case of the band pass filter). There may be other opportunistic
cancellations, but it will not check for them.

Also note that any pole on the unit circle or beyond will result in an
unstable filter. Because of cancellation, this will only happen if the number
of poles is smaller than the number of zeros. The analytic design methods all
yield more poles than zeros, so this will not be a problem.
}
\examples{
## 6th order Bessel low-pass analog filter
zp <- besselap(6)
w <- seq(0, 4, length.out = 128)
freqs(zp, w)
zzp <- bilinear(zp)
freqz(zzp)

}
\references{
\url{https://en.wikipedia.org/wiki/Bilinear_transform}
}
\author{
Paul Kienzle \email{pkienzle@users.sf.net}. Conversion to R by Tom
  Short, adapted by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
