% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bohmanwin.R
\name{bohmanwin}
\alias{bohmanwin}
\title{Bohman window}
\usage{
bohmanwin(n)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}
}
\value{
Bohman window, returned as a vector. If you specify a one-point
  window \code{(n = 1)}, the value 1 is returned.
}
\description{
Return the filter coefficients of a Bohman window.
}
\details{
A Bohman window is the convolution of two half-duration cosine lobes. In the
time domain, it is the product of a triangular window and a single cycle of a
cosine with a term added to set the first derivative to zero at the boundary.
}
\examples{

b <- bohmanwin(64)
plot (b, type = "l", xlab = "Samples", ylab =" Amplitude")

}
\seealso{
\code{\link{triang}}
}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
