% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{confintd}
\alias{confintd}
\title{Confidence intervals for derived parameters}
\usage{
confintd(object, expr, level = 0.95, ...)
}
\arguments{
\item{object}{A fitted model object.}

\item{expr}{An expression or character vector that can be transformed to an \code{\link{expression}}
giving the function(s) of the parameters to be evaluated. Each expression should evaluate to a numeric scalar.}

\item{level}{A numeric scalar between 0 and 1 giving the level of the derived parameter confidence intervals.}

\item{...}{Additional argument(s) for methods}
}
\value{
A matrix with columns giving the fitted values and lower and upper confidence limits for
each derived parameter. The row names list the individual derived parameter expressions.
}
\description{
\code{confintd} is a generic function to compute confidence intervals for continuous functions
of the parameters in a fitted model. The function invokes particular \emph{methods} which depend on the
\code{\link{class}} of the first argument.
}
\seealso{
\code{\link[stats]{confint}}
}
