% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{fitted.gsl_nls}
\alias{fitted.gsl_nls}
\title{Extract model fitted values}
\usage{
\method{fitted}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Numeric vector of fitted responses similar to \code{\link[stats]{fitted}}.
}
\description{
Returns the fitted responses from a \code{"gsl_nls"} object. \code{fitted.values}
can also be used as an alias.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## model
obj <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
fitted(obj)
}
\seealso{
\code{\link[stats]{fitted}}
}
