% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_test.R
\name{nls_test_problem}
\alias{nls_test_problem}
\title{Retrieve an NLS test problem}
\usage{
nls_test_problem(name, p = NA, n = NA)
}
\arguments{
\item{name}{Name of the NLS test problem, as returned in the \code{"name"} column of \code{\link{nls_test_list}}.}

\item{p}{The number of parameters in the NLS test problem constrained by the \code{check} condition returned by \code{\link{nls_test_list}}.
If \code{NA} (default), the default number of parameters as listed by \code{\link{nls_test_list}} is used.}

\item{n}{The number of residuals in the NLS test problem constrained by the \code{check} condition returned by \code{\link{nls_test_list}}.
If \code{NA} (default), the default number of residuals as listed by \code{\link{nls_test_list}} is used.}
}
\value{
If the model is defined as a \link{formula}, a \link{list} of class \code{"nls_test_formula"} with elements:
\itemize{
\item \code{data} a data.frame with \code{n} rows containing the data (predictor and response values) used in the regression problem.
\item \code{fn} a \link{formula} defining the test problem model.
\item \code{start} a named vector of length \code{p} with suggested starting values for the parameters.
\item \code{target} a named vector of length \code{p} with the certified target values for the parameters corresponding to the
\emph{best-available} solutions.
}
If the model is defined as a \link{function}, a \link{list} of class \code{"nls_test_function"} with elements:
\itemize{
\item \code{fn} a \link{function} defining the test problem model. \code{fn} takes a vector of parameters
of length \code{p} as its first argument and returns a numeric vector of length \code{n}.
\code{fn}
\item \code{y} a numeric vector of length \code{n} containing the response values.
\item \code{start} a numeric named vector of length \code{p} with suggested starting values for the parameters.
\item \code{jac} a \link{function} defining the analytic Jacobian matrix of the model \code{fn}. \code{jac}
takes a vector of parameters of length \code{p} as its first argument and returns an \code{n} by \code{p} dimensional matrix.
\item \code{target} a numeric named vector of length \code{p} with the certified target values for the parameters, or a vector of
\code{NA}'s if no target solution is available.
}
}
\description{
Fetches the model definition and model data required to solve a single NLS test problem with \code{\link{gsl_nls}}
(or \code{\link[stats]{nls}} if the model is defined as a \link{formula}). Use \code{\link{nls_test_list}} to
list the names of the available NLS test problems.
}
\note{
For several problems the optimal least-squares objective of the target solution can be obtained at multiple different parameter locations.
}
\examples{
## example regression problem
ratkowsky2 <- nls_test_problem(name = "Ratkowsky2")
with(ratkowsky2,
     gsl_nls(
       fn = fn,
       data = data,
       start = start
     )
)

## example optimization problem
rosenbrock <- nls_test_problem(name = "Rosenbrock")
with(rosenbrock,
     gsl_nls(
       fn = fn,
       y = y,
       start = start,
       jac = jac
     )
)
}
\references{
D.M. Bates and Watts, D.G. (1988). \emph{Nonlinear Regression Analysis and Its Applications}, Wiley, ISBN: 0471816434.

J.J. Moré, Garbow, B.S. and Hillstrom, K.E. (1981). \emph{Testing unconstrained optimization software}, ACM Transactions on Mathematical Software, 7(1), 17-41.
}
\seealso{
\code{\link{nls_test_list}}

\url{https://www.itl.nist.gov/div898/strd/nls/nls_main.shtml}

\url{https://people.math.sc.edu/Burkardt/f_src/test_nls/test_nls.html}
}
