\name{geom_locus}
\alias{geom_locus}
\title{Translate a vector of \code{locus} objects into a \code{gemo_bars} layer}
\usage{
geom_locus(mapping, data, ...)
}
\arguments{
  \item{mapping}{The aesthetic mapping (e.g., which locus
  to use).  Use \code{aes(x=LOCUS_NAME)} to specify which
  locus is being used.}

  \item{data}{A \code{data.frame} containing one or more
  loci to be plot}

  \item{...}{Added to geom_bar}
}
\value{
A formatted set of \code{ggplot} objects to be plot
}
\description{
This function takes a data frame containing genetic data
and returns a \code{geom_bars} layer for \code{ggplot}
integration.
}
\note{
If using more than one stratum, use fill=STRATA_NAME for
partitioning
}
\examples{
require(ggplot2)
loci <- c( locus(1:2), locus(2:3), locus(c(1,1)), locus(1:2) )
data <- data.frame( Population=c("A","A","B","B"), Locus=loci)
ggplot() + geom_locus( aes(x=Locus, fill=Population), data=data )
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

