% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_beta_const_t_exact}
\alias{gsw_beta_const_t_exact}
\title{Saline contraction coefficient at constant in-situ temperature}
\usage{
gsw_beta_const_t_exact(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
saline contraction coefficient at constant in-situ temperature [ kg/g ]
}
\description{
Saline contraction coefficient at constant in-situ temperature
}
\examples{
gsw_beta_const_t_exact(34.7118, 28.7856, 10) # 7.31120837010429e-4
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_beta_const_t_exact.html}
}
\seealso{
A related function is \code{\link{gsw_beta}}.
}

