% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_t_freezing}
\alias{gsw_t_freezing}
\title{Freezing temperature}
\usage{
gsw_t_freezing(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [ dbar ]}

\item{saturation_fraction}{saturation fraction of dissolved air in seawater}
}
\value{
in-situ freezing temperature (ITS-90) [ deg C ]
}
\description{
Note: as of 2014-12-23, this corresponds to the Matlab function
called \code{gsw_t_freezing_poly}. (The confusion arises from a
mismatch in release version between the Matlab and C libraries.)
}
\examples{
gsw_t_freezing(34.7118, 10) # -1.902704434299200
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_t_freezing.html}
\url{http://www.teos-10.org/pubs/gsw/html/gsw_t_freezing_poly.html}
}
\seealso{
\code{\link{gsw_CT_freezing}} is the analogue for Conservative Temperature.
}

