% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_second_derivatives}
\alias{gsw_CT_second_derivatives}
\title{Second Derivatives of Conservative Temperature}
\usage{
gsw_CT_second_derivatives(SA, pt)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{pt}{potential temperature (ITS-90) [ degC ]}
}
\value{
A list containing \code{CT_SA_SA} [ K/(g/kg)^2 ], the second derivative of
Conservative Temperature with respect to Absolute Salinity at constant
potential temperature, and \code{CT_SA_pt} [ 1/(g/kg) ], the derivative of
Conservative Temperature with respect to potential temperature and
Absolute Salinity, and \code{CT_pt_pt} [ 1/degC ], the second derivative of
Conservative Temperature with respect to potential temperature.
}
\description{
Second Derivatives of Conservative Temperature
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
pt <- c(28.7832, 28.4209, 22.7850, 10.2305,  6.8292,  4.3245)
r <- gsw_CT_second_derivatives(SA, pt)
expect_equal(r$CT_SA_SA/1e-3, c(-0.060718502077064, -0.062065324400873, -0.084017055354742,
                              -0.148436050120131, -0.171270386500246, -0.189920754900116))
expect_equal(r$CT_SA_pt, c(-0.001197415000869, -0.001198309530139, -0.001226523296082,
                         -0.001335896286481, -0.001380492698572, -0.001417751669135))
expect_equal(r$CT_pt_pt/1e-3, c(0.123012754427146, 0.124662008871271, 0.140829458783443,
                              0.140646803448166, 0.113684095615077, 0.082286843477998))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_second_derivatives.html}
}
