% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SP_from_SR}
\alias{gsw_SP_from_SR}
\title{Calculate Practical Salinity from Reference Salinity}
\usage{
gsw_SP_from_SR(SR)
}
\arguments{
\item{SR}{Reference Salinity [ g/kg ]}
}
\value{
Practical Salinity (PSS-78) [ unitless ]
}
\description{
Calculate Practical Salinity from Reference Salinity
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SR <- c(34.5487, 34.7275, 34.8605, 34.6810, 34.5680, 34.5600)
SP <- gsw_SP_from_SR(SR)
expect_equal(SP, c(34.386552667080714, 34.564513505458834, 34.696889296869848,
                   34.518231743800094, 34.405762086435850, 34.397799632817147))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SP_from_SR.html}
}
\seealso{
Other things related to salinity: \code{\link{gsw_C_from_SP}},
  \code{\link{gsw_SA_from_SP_Baltic}},
  \code{\link{gsw_SA_from_SP}},
  \code{\link{gsw_SA_from_Sstar}},
  \code{\link{gsw_SP_from_C}},
  \code{\link{gsw_SP_from_SA}},
  \code{\link{gsw_SP_from_SK}},
  \code{\link{gsw_SP_from_Sstar}},
  \code{\link{gsw_SR_from_SP}},
  \code{\link{gsw_Sstar_from_SA}},
  \code{\link{gsw_Sstar_from_SP}},
  \code{\link{gsw_deltaSA_from_SP}}
}
