% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_stub_indent}
\alias{tab_stub_indent}
\title{Control indentation of row labels in the stub}
\usage{
tab_stub_indent(data, rows, indent = "increase")
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{rows}{\emph{Rows to target}

\verb{<row-targeting expression>} // \strong{required}

The rows to consider for the indentation change. The default \code{\link[=everything]{everything()}}
results in all rows being targeted. Alternatively, we can supply a vector
of row captions within \code{\link[=c]{c()}}, a vector of row indices, or a select helper
function. Examples of select helper functions include \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}. We can also use expressions to filter down to the rows we
need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{indent}{\emph{Indentation directive}

\verb{scalar<character|numeric|integer>} // \emph{default:} \code{"increase"}

An indentation directive either as a keyword describing the indentation
change or as an explicit integer value for directly setting the indentation
level. The keyword \code{"increase"} (the default) will increase the indentation
level by one; \code{"decrease"} will do the same in the reverse direction. The
starting indentation level of \code{0} means no indentation and this values
serves as a lower bound. The upper bound for indentation is at level \code{5}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Indentation of row labels is an effective way for establishing structure in a
table stub. The \code{tab_stub_indent()} function allows for fine control over
row label indentation in the stub. We can use an explicit definition of an
indentation level, or, employ an indentation directive using keywords.
}
\section{Compatibility of arguments with the \code{from_column()} helper function}{


The \code{\link[=from_column]{from_column()}} helper function can be used with the \code{indent} argument
of \code{tab_stub_indent()} to obtain varying parameter values from a specified
column within the table. This means that each row label could be indented a
little bit differently.

Please note that for this argument (\code{indent}), a \code{\link[=from_column]{from_column()}} call needs
to reference a column that has data of the \code{numeric} or \code{integer} type.
Additional columns for parameter values can be generated with the
\code{\link[=cols_add]{cols_add()}} function (if not already present). Columns that contain
parameter data can also be hidden from final display with \code{\link[=cols_hide]{cols_hide()}}.
}

\section{Examples}{


Let's use a summarized version of the \code{\link{pizzaplace}} dataset to create a
\strong{gt} table with row groups and row labels. With the \code{\link[=summary_rows]{summary_rows()}}
function, we'll generate summary rows at the top of each row group. With
\code{tab_stub_indent()} we can add indentation to the row labels in the stub.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pizzaplace |>
  dplyr::group_by(type, size) |>
  dplyr::summarize(
    sold = dplyr::n(),
    income = sum(price),
    .groups = "drop"
  ) |>
  gt(rowname_col = "size", groupname_col = "type") |>
  tab_header(title = "Pizzas Sold in 2015") |>
  fmt_integer(columns = sold) |>
  fmt_currency(columns = income) |>
  summary_rows(
    fns = list(label = "All Sizes", fn = "sum"),
    side = "top",
    fmt = list(
      ~ fmt_integer(., columns = sold),
      ~ fmt_currency(., columns = income)
    )
  ) |>
  tab_options(
    summary_row.background.color = "gray95",
    row_group.background.color = "#FFEFDB",
    row_group.as_column = TRUE
  ) |>
  tab_stub_indent(
    rows = everything(),
    indent = 2
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_stub_indent_1.png" alt="This image of a table was generated from the first code example in the `tab_stub_indent()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-6
}

\section{Function Introduced}{

\code{v0.7.0} (Aug 25, 2022)
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_caption}()},
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_info}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style_body}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
