% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_transform.R
\name{text_case_when}
\alias{text_case_when}
\title{Perform whole text replacements using a 'case-when'-expression approach}
\usage{
text_case_when(.data, ..., .default = NULL, .locations = cells_body())
}
\arguments{
\item{.data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{...}{\emph{Matching expressions}

\verb{<multiple expressions>} // \strong{required}

A sequence of two-sided formulas. The left hand side (LHS)
determines which values match this case. The right hand side (RHS) provides
the replacement text (it must resolve to a value of the \code{character} class).
The LHS inputs must evaluate to logical vectors.}

\item{.default}{\emph{Default replacement text}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The replacement text to use when cell values aren't matched by any of the
LHS inputs. If \code{NULL}, the default, no replacement text will be used.}

\item{.locations}{\emph{Locations to target}

\code{\link[=location-helper]{<locations expressions>}} // \emph{default:} \code{cells_body()}

The cell or set of cells to be associated with the text transformation.
Only \code{\link[=cells_column_spanners]{cells_column_spanners()}}, \code{\link[=cells_column_labels]{cells_column_labels()}},
\code{\link[=cells_row_groups]{cells_row_groups()}}, \code{\link[=cells_stub]{cells_stub()}}, and \code{\link[=cells_body]{cells_body()}} can
be used here. We can enclose several of these calls within a \code{list()} if we
wish to make the transformation happen at different locations.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{text_case_when()} provides a useful interface for a case-by-case approach to
replacing entire table cells. First off, you have to make sure you're
targeting the appropriate cells with the \code{.locations} argument. Following
that, you supply a sequence of two-sided formulas matching of the general
form: \verb{<logical_stmt> ~ <new_text>}. In the left hand side (LHS) there should
be a predicate statement that evaluates to a logical vector of length one
(i.e., either \code{TRUE} or \code{FALSE}). To refer to the values undergoing
transformation, you need to use the \code{x} variable.
}
\section{Examples}{


Use a portion of the \code{\link{metro}} dataset to create a \strong{gt} table. We'll use
\code{text_case_when()} to supply pairs of predicate statements and replacement
text. For the \code{connect_rer} column, we will perform a count of pattern
matches with \code{stringr::str_count()} and determine which cells have 1, 2, or 3
matched patterns. For each of these cases, descriptive replacement text is
provided. Here, we use a \code{.default} value to replace the non-matched
cases with an empty string (\code{""}). Finally, we use \code{\link[=cols_label]{cols_label()}} to modify
the labels of the three columns.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{metro |>
  dplyr::arrange(desc(passengers)) |>
  dplyr::select(name, lines, connect_rer) |>
  dplyr::slice_head(n = 10) |>
  gt() |>
  text_case_when(
    stringr::str_count(x, pattern = "[ABCDE]") == 1 ~ "One connection.",
    stringr::str_count(x, pattern = "[ABCDE]") == 2 ~ "Two connections.",
    stringr::str_count(x, pattern = "[ABCDE]") == 3 ~ "Three connections.",
    .default = "", .locations = cells_body(columns = connect_rer)
  ) |>
  cols_label(
    name = "Station",
    lines = "Lines Serviced",
    connect_rer = "RER Connections"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_text_case_when_1.png" alt="This image of a table was generated from the first code example in the `text_case_when()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

4-2
}

\section{Function Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
Other text transforming functions: 
\code{\link{text_case_match}()},
\code{\link{text_replace}()},
\code{\link{text_transform}()}
}
\concept{text transforming functions}
