% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_stub}
\alias{cells_stub}
\title{Location helper for targeting cells in the table stub}
\usage{
cells_stub(rows = TRUE)
}
\arguments{
\item{rows}{The names of the rows that are to be targeted.}
}
\value{
A list object with the classes \code{cells_stub} and \code{location_cells}.
}
\description{
The \code{cells_stub()} function is used to target the table's stub cells and it
is useful when applying a footnote with \code{\link[=tab_footnote]{tab_footnote()}} or adding a custom
style with \code{\link[=tab_style]{tab_style()}}. The function is expressly used in each of those
functions' \code{locations} argument.
}
\details{
When using any of the location helper functions with an appropriate function
that has a \code{locations} argument, multiple locations can be targeted by
enclosing several \verb{cells_*()} helper functions in a \code{list()}. The following
helper functions can be used to target cells (roughly in order from the top
to the bottom of a table):
\itemize{
\item \code{\link[=cells_title]{cells_title()}}: targets the table title or the table subtitle
depending on the value given to the \code{groups} argument (\code{"title"} or
\code{"subtitle"}).
\item \code{\link[=cells_stubhead]{cells_stubhead()}}: targets the stubhead location, a cell of which is
only available when there is a stub; a label in that location can be created
by using the \code{\link[=tab_stubhead]{tab_stubhead()}} function.
\item \code{\link[=cells_column_spanners]{cells_column_spanners()}}: targets the spanner column labels, which
appear above the column labels.
\item \code{\link[=cells_column_labels]{cells_column_labels()}}: targets the column labels.
\item \code{\link[=cells_row_groups]{cells_row_groups()}}: targets the row group labels in any available row
groups using the \code{groups} argument.
\item \code{\link[=cells_stub]{cells_stub()}}: targets row labels in the table stub using the \code{rows}
argument.
\item \code{\link[=cells_body]{cells_body()}}: targets data cells in the table body using
intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_summary]{cells_summary()}}: targets summary cells in the table body using the
\code{groups} argument and intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_grand_summary]{cells_grand_summary()}}: targets cells of the table's grand summary
using intersections of \code{columns} and \code{rows}
}
}
\section{Figures}{

\if{html}{\figure{man_cells_stub_1.png}{options: width=100\%}}
}

\section{Function ID}{

7-10
}

\examples{
library(tidyr)

# Use `sza` to create a gt table; color
# all of the `month` values in the table
# stub with `tab_style()`, using `cells_stub()`
# in `locations` (`rows = TRUE` targets
# all stub rows)
tab_1 <-
  sza \%>\%
  dplyr::filter(latitude == 20 & tst <= "1000") \%>\%
  dplyr::select(-latitude) \%>\%
  dplyr::filter(!is.na(sza)) \%>\%
  tidyr::spread(key = "tst", value = sza) \%>\%
  gt(rowname_col = "month") \%>\%
  fmt_missing(
    columns = TRUE,
    missing_text = ""
  ) \%>\%
  tab_style(
    style = list(
      cell_fill(color = "darkblue"),
      cell_text(color = "white")
      ),
    locations = cells_stub(rows = TRUE)
  )

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
