% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_move_to_end}
\alias{cols_move_to_end}
\title{Move one or more columns to the end}
\usage{
cols_move_to_end(data, columns)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The column names to move to the right-most side of the table.
The order in which columns are provided will be preserved (as is the case
with the remaining columns).}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
It's possible to move a set of columns to the end of the column series, we
only need to specify which \code{columns} are to be moved. While this can be done
upstream of \strong{gt}, this function makes to process much easier and it's less
error prone. The ordering of the \code{columns} that are moved to the end is
preserved (same with the ordering of all other columns in the table).
}
\details{
The columns supplied in \code{columns} must all exist in the table. If you need to
place one or columns at the start of the column series, the
\code{\link[=cols_move_to_start]{cols_move_to_start()}} function should be used. More control is offered with
the \code{\link[=cols_move]{cols_move()}} function, where columns could be placed after a specific
column.
}
\section{Figures}{

\if{html}{\figure{man_cols_move_to_end_1.png}{options: width=100\%}}

\if{html}{\figure{man_cols_move_to_end_2.png}{options: width=100\%}}
}

\section{Function ID}{

4-5
}

\examples{
# Use `countrypops` to create a gt table;
# With the remaining columns, move the
# `year` column to the end
tab_1 <-
  countrypops \%>\%
  dplyr::select(-contains("code")) \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_move_to_end(
    columns = year
  )

# Use `countrypops` to create a gt table;
# With the remaining columns, move `year`
# and `country_name` to the end
tab_2 <-
  countrypops \%>\%
  dplyr::select(-contains("code")) \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_move_to_end(
    columns = c(year, country_name)
  )

}
\seealso{
Other Modify Columns: 
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_unhide}()},
\code{\link{cols_width}()}
}
\concept{Modify Columns}
