% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_hide}
\alias{cols_hide}
\title{Hide one or more columns}
\usage{
cols_hide(data, columns)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The column names to hide from the output display table. Values
provided that do not correspond to column names will be disregarded.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{cols_hide()} function allows us to hide one or more columns from
appearing in the final output table. While it's possible and often desirable
to omit columns from the input table data before introduction to the \code{\link[=gt]{gt()}}
function, there can be cases where the data in certain columns is useful (as
a column reference during formatting of other columns) but the final display
of those columns is not necessary.
}
\details{
The hiding of columns is internally a rendering directive, so, all columns
that are 'hidden' are still accessible and useful in any expression provided
to a \code{rows} argument. Furthermore, the \code{cols_hide()} function (as with many
\strong{gt} functions) can be placed anywhere in a pipeline of \strong{gt} function
calls (acting as a promise to hide columns when the timing is right). However
there's perhaps greater readability when placing this call closer to the end
of such a pipeline. The \code{cols_hide()} function quietly changes the visible
state of a column (much like the \code{\link[=cols_unhide]{cols_unhide()}} function) and doesn't yield
warnings or messages when changing the state of already-invisible columns.
}
\section{Examples}{


Use \code{\link{countrypops}} to create a \strong{gt} table. Hide the \code{country_code_2} and
\code{country_code_3} columns with \code{cols_hide()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_hide(columns = c(country_code_2, country_code_3))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_hide_1.png" style="width:100\%;">
}}

Use \code{\link{countrypops}} to create a \strong{gt} table. Use the \code{population} column to
provide the conditional placement of footnotes, then hide that column and one
other. Note that the order of the \code{cols_hide()} and \code{\link[=tab_footnote]{tab_footnote()}}
statements has no effect.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_hide(columns = c(country_code_3, population)) \%>\%
  tab_footnote(
    footnote = "Population above 3,000,000.",
    locations = cells_body(
      columns = year,
      rows = population > 3000000
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_hide_2.png" style="width:100\%;">
}}
}

\section{Function ID}{

4-7
}

\seealso{
\code{\link[=cols_unhide]{cols_unhide()}} to perform the inverse operation.

Other Modify Columns: 
\code{\link{cols_align}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_unhide}()},
\code{\link{cols_width}()}
}
\concept{Modify Columns}
