% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_rtf}
\alias{as_rtf}
\title{Output a \strong{gt} object as RTF}
\usage{
as_rtf(data)
}
\arguments{
\item{data}{A table object that is created using the \code{gt()} function.}
}
\description{
Get the RTF content from a \code{gt_tbl} object as as a single-element character
vector. This object can be used with \code{writeLines()} to generate a valid .rtf
file that can be opened by RTF readers.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. Add a header and then export as RTF
code.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_rtf <-
  gtcars \%>\%
  dplyr::select(mfr, model) \%>\%
  dplyr::slice(1:2) \%>\%
  gt() \%>\%
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) \%>\%
  as_rtf()
}\if{html}{\out{</div>}}
}

\section{Function ID}{

13-4
}

\seealso{
Other table export functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_word}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
