% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_bullet.R
\name{gt_plt_bullet}
\alias{gt_plt_bullet}
\title{Create an inline 'bullet chart' in a gt table}
\usage{
gt_plt_bullet(
  gt_object,
  column = NULL,
  target = NULL,
  width = 65,
  palette = c("grey", "red")
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column where a 'bullet chart' will replace the inline values.}

\item{target}{The column indicating the target values that will be represented by a vertical line}

\item{width}{Width of the plot in pixels}

\item{palette}{Color of the bar and target line, defaults to \code{c("grey", "red")}, can use named colors or hex colors. Must be of length two, and the first color will always be used as the bar color.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Create an inline 'bullet chart' in a gt table
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{set.seed(37)
bullet_tab <- tibble::rownames_to_column(mtcars) \%>\%
 dplyr::select(rowname, cyl:drat, mpg) \%>\%
 dplyr::group_by(cyl) \%>\%
 dplyr::mutate(target_col = mean(mpg)) \%>\%
 dplyr::slice_sample(n = 3) \%>\%
 dplyr::ungroup() \%>\%
 gt::gt() \%>\%
 gt_plt_bullet(column = mpg, target = target_col, width = 45,
               palette = c("lightblue", "black")) \%>\%
 gt_theme_538()
}\if{html}{\out{</div>}}

\if{html}{\figure{gt_bullet.png}{options: width=100\%}}
}

\section{Function ID}{

3-7
}

\seealso{
Other Themes: 
\code{\link{gt_plt_conf_int}()},
\code{\link{gt_plt_dot}()},
\code{\link{gt_theme_538}()},
\code{\link{gt_theme_dark}()},
\code{\link{gt_theme_dot_matrix}()},
\code{\link{gt_theme_espn}()},
\code{\link{gt_theme_excel}()},
\code{\link{gt_theme_guardian}()},
\code{\link{gt_theme_nytimes}()}
}
\concept{Themes}
