% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_text_img.R
\name{add_text_img}
\alias{add_text_img}
\title{Add text and an image to the left or right of it}
\usage{
add_text_img(text, url, height = 30, left = FALSE)
}
\arguments{
\item{text}{A text string to be added to the cell.}

\item{url}{A url that resolves to an image file.}

\item{height}{The absolute height (px) of the image in the table cell.}

\item{left}{A logical TRUE/FALSE indicating if text should be on the left (TRUE) or right (FALSE)}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{add_text_img} function takes an existing \code{gt_tbl} object and
adds some user specified text and an image url to a specific cell. This is a
wrapper raw HTML strings and \code{gt::web_image()}. Intended to be used inside
the header of a table via \code{gt::tab_header()}.
}
\section{Function ID}{

2-5
}

\section{Figures}{

\if{html}{\figure{title-car.png}{options: width=70\%}}
}

\examples{
library(gt)
title_car <- mtcars \%>\%
  head() \%>\%
  gt() \%>\%
  gt::tab_header(
    title = add_text_img(
      "A table about cars made with",
      url = "https://www.r-project.org/logo/Rlogo.png"
      )
    )
}
\seealso{
Other Utilities: 
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
