% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt-bar-html.R
\name{gt_plt_bar_pct}
\alias{gt_plt_bar_pct}
\title{Add HTML-based bar plots into rows of a \code{gt} table}
\usage{
gt_plt_bar_pct(
  gt_object,
  column,
  height = 16,
  fill = "purple",
  background = "#e1e1e1",
  scaled = FALSE
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column wherein the bar plot should replace existing data.}

\item{height}{A number representing the vertical height of the plot in pixels. Defaults to 16 px.}

\item{fill}{A character representing the fill for the bar, defaults to purple. Accepts a named color (eg 'purple') or a hex color.}

\item{background}{A character representing the background filling out the 100\% mark of the bar, defaults to light grey. Accepts a named color (eg 'white') or a hex color.}

\item{scaled}{\code{TRUE}/\code{FALSE} logical indicating if the value is already scaled to a percent of max (\code{TRUE}) or if it needs to be scaled (\code{FALSE}). Defaults to \code{FALSE}, meaning the value will be divided by the max value in that column and then multiplied by 100.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_plt_bar_pct} function takes an existing \code{gt_tbl} object and
adds horizontal barplots via native HTML. This is a wrapper around raw HTML
strings, \code{gt::text_transform()} and \code{gt::cols_align()}. Note that values
default to being normalized to the percent of the maximum observed value
in the specified column. You can turn this off if the values already
represent a percentage value representing 0-100.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
 gt_bar_plot_tab <- mtcars \%>\%
   head() \%>\%
   dplyr::select(cyl, mpg) \%>\%
   dplyr::mutate(mpg_pct_max = round(mpg/max(mpg) * 100, digits = 2),
                 mpg_scaled = mpg/max(mpg) * 100) \%>\%
   dplyr::mutate(mpg_unscaled = mpg) \%>\%
   gt() \%>\%
   gt_plt_bar_pct(column = mpg_scaled, scaled = TRUE) \%>\%
   gt_plt_bar_pct(column = mpg_unscaled, scaled = FALSE,
                  fill = "blue", background = "lightblue") \%>\%
   cols_align("center", contains("scale")) \%>\%
   cols_width(4 ~ px(125),
              5 ~ px(125))
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_bar_plot.png}{options: width=100\%}}
}

\section{Function ID}{

3-5
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_sparkline}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
