% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genomic_features.R
\name{get_genomic_features}
\alias{get_genomic_features}
\title{Get Genomic Features}
\usage{
get_genomic_features(.featureId, datasetId = "gtex_v8", .return_raw = FALSE)
}
\arguments{
\item{.featureId}{String. A genomic feature e.g. GENCODE ID, RSID or
GTEx Variant ID.}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
\href{https://gtexportal.org/api/v2/redoc#tag/Reference-Genome-Endpoints/operation/get_genomic_features_api_v2_reference_features__featureId__get}{GTEx API Portal documentation}
}
\details{
This endpoint takes a path parameter "featureId".
}
\examples{
\dontrun{
# gene symbol
get_genomic_features("brca1")

# GENCODE ID
get_genomic_features("ENSG00000132693.12")

# RSID
get_genomic_features("rs1815739")

# GTEx variant ID
get_genomic_features("chr11_66561023_G_GTTA_b38")
}
}
\seealso{
Other Reference Genome Endpoints: 
\code{\link{get_exons}()},
\code{\link{get_gene_search}()},
\code{\link{get_genes}()},
\code{\link{get_gwas_catalog_by_location}()},
\code{\link{get_neighbor_gene}()},
\code{\link{get_transcripts}()}
}
\concept{Reference Genome Endpoints}
