% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_image.R
\name{get_image}
\alias{get_image}
\title{Get Image}
\usage{
get_image(
  tissueSampleIds = NULL,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{tissueSampleIds}{Array of strings. A list of Tissue Sample ID(s).}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
\href{https://gtexportal.org/api/v2/redoc#tag/Histology-Endpoints/operation/get_image_api_v2_histology_image_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
get_image()

# filter by `tissueSampleId`
result <- get_image(tissueSampleIds = "GTEX-1117F-0526")
print(result)

# note that `pathologyNotesCategories` (if present) is a list column
print(result$pathologyNotesCategories)
}
}
\concept{Histology Endpoints}
