% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_files_exist}
\alias{check_files_exist}
\alias{assert_files_exist}
\title{Check the existence of text files in a GTFS object}
\usage{
check_files_exist(x, files)

assert_files_exist(x, files)
}
\arguments{
\item{x}{A GTFS object.}

\item{files}{A character vector. The files to check the existence of.}
}
\value{
\code{check_files_exist} returns \code{TRUE} if the check is successful, and
  \code{FALSE} otherwise. \cr
\code{assert_files_exist} returns \code{x} invisibly if the check is
  successful, and throws an error otherwise.
}
\description{
Checks the existence of elements inside a GTFS object that represent specific
GTFS text files.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")
gtfs <- import_gtfs(gtfs_path)

check_files_exist(gtfs, c("calendar", "agency"))

check_files_exist(gtfs, c("calendar", "oi"))

}
\seealso{
Other checking functions: 
\code{\link{check_fields_exist}()},
\code{\link{check_fields_types}()}
}
\concept{checking functions}
