% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timetable.R
\name{gtfs_timetable}
\alias{gtfs_timetable}
\title{gtfs_timetable}
\usage{
gtfs_timetable(
  gtfs,
  day = NULL,
  date = NULL,
  route_pattern = NULL,
  quiet = FALSE
)
}
\arguments{
\item{gtfs}{A set of GTFS data returned from \link{extract_gtfs}.}

\item{day}{Day of the week on which to calculate route, either as an
unambiguous string (so "tu" and "th" for Tuesday and Thursday), or a number
between 1 = Sunday and 7 = Saturday. If not given, the current day will be
used - unless the following 'date' parameter is give.}

\item{date}{Some systems do not specify days of the week within their
'calendar' table; rather they provide full timetables for specified calendar
dates via a 'calendar_date' table. Providing a date here as a single 8-digit
number representing 'yyyymmdd' will filter the data to the specified date.}

\item{route_pattern}{Using only those routes matching given pattern, for
example, "^U" for routes starting with "U" (as commonly used for underground
or subway routes.}

\item{quiet}{Set to \code{TRUE} to suppress screen messages (currently just
regarding timetable construction).}
}
\value{
The input data with an addition items, \code{timetable}, \code{stations}, and
\code{trips}, containing data formatted for more efficient use with
\link{gtfs_route} (see Note).
}
\description{
Convert GTFS data into format able to be used to calculate routes.
}
\note{
This function is merely provided to speed up calls to the primary
function, \link{gtfs_route}. If the input data to that function do not
include a formatted \code{timetable}, it will be calculated anyway, but queries in
that case will generally take longer.
}
\examples{
berlin_gtfs_to_zip () # Write sample feed from Berlin, Germany to tempdir
f <- file.path (tempdir (), "vbb.zip") # name of feed
gtfs <- extract_gtfs (f)
from <- "Innsbrucker Platz" # U-bahn station, not "S"
to <- "Alexanderplatz"
start_time <- 12 * 3600 + 120 # 12:02
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time)

# Specify day of week
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time,
                     day = "Sunday")

# specify travel by "U" = underground only
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time,
                     day = "Sunday", route_pattern = "^U")
# specify travel by "S" = street-level only (not underground)
route <- gtfs_route (gtfs, from = from, to = to, start_time = start_time,
                     day = "Sunday", route_pattern = "^S")

# Route queries are generally faster if the GTFS data are pre-processed with
# `gtfs_timetable()`:
gt <- gtfs_timetable (gtfs, day = "Sunday", route_pattern = "^S")
route <- gtfs_route (gt, from = from, to = to, start_time = start_time)

}
