% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_table1.R
\name{fmt_table1}
\alias{fmt_table1}
\title{Calculates and formats descriptive statistics for Table 1.}
\usage{
fmt_table1(data, by = NULL, label = NULL, type = NULL,
  statistic = NULL, digits = NULL, id = NULL, missing = c("ifany",
  "always", "no"))
}
\arguments{
\item{data}{data frame.}

\item{by}{a character name of a categorical variable in data, \code{by = "group"}.
Summary statistics will be calculated separately for each level of the by variable.
If \code{NULL}, summary statistics
are calculated using all observations.}

\item{label}{A list of variable labels,
e.g. \code{list(age = "Age, yrs", ptstage = "Path T Stage")}.  If \code{NULL}, the function
will take the label attribute (\code{attr(data$age, "label")}).  If
the label doesn't exist, then the label is assigned as the variable name.}

\item{type}{A list that includes specified summary types.  Accepted values
are \code{c("continuous", "categorical", "dichotomous")},
e.g. \code{type = list(age = "continuous", female = "dichotomous")}.
If type not specified for a variable, the function
will default to an appropriate summary type.}

\item{statistic}{A list of the type of statistics to return.  The list can contain
two names lists (\code{continuous} and \code{categorical}).  The value within the list is the types of
summary statistics to be returned.  For continuous variables the choices are:
\code{median}, \code{q1} (first quartile), \code{q3} (third quartile), \code{mean}, \code{sd} (standard deviation),
\code{min} (minimum), \code{max} (maximum).  For categorical variables the choices are \code{n} (frequency),
\code{N} (denominator, or cohort size), \code{p} (percent).  The defaults are
\code{continuous = "{median} ({q1}, {q3})"} and \code{categorical = "{n} ({p}\\\%)"}.
The syntax follows from the \code{\link[glue]{glue}} function.  Dichotomous variables
follow the same format as categorical.}

\item{digits}{integer indicating the number of decimal places to round continuous
summary statistics. \code{sprintf(glue::glue("\%.{digits}f"), x)}}

\item{id}{Character vector of an ID or grouping variable.  Summary statistics
will not be printed for this column. The column may be used in \code{\link{add_comparison}} to
calculate p-values with correlated data. Default is \code{NULL}}

\item{missing}{whether to include \code{NA} values in the table. \code{missing} controls
if the table includes counts of \code{NA} values: the allowed values correspond to
never (\code{"no"}), only if the count is positive (\code{"ifany"}) and even for
zero counts (\code{"always"}). Default is \code{"ifany"}.}
}
\value{
Data frame including formatted descriptive statistics.
}
\description{
The \code{fmt_table1} function calculates descriptive statistics by groups for
continuous, categorical, and dichotomous variables.  Review the \code{fmt_table1}
vignette for detailed examples.
}
\examples{
fmt_table1(trial, by = "trt")

# convert numeric 'am' to factor to display nicely in header
mtcars \%>\%
  dplyr::mutate(am = factor(am, c(0, 1), c("Automatic", "Manual"))) \%>\%
  fmt_table1(by = "am") \%>\%
  add_comparison()
}
