% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_uni_regression.R
\name{fmt_uni_regression}
\alias{fmt_uni_regression}
\title{Creates table of univariate regression results}
\usage{
fmt_uni_regression(data, method, y, method.args = NULL,
  formula = "{y} ~ {.x}", exponentiate = FALSE, label = NULL,
  show_yesno = NULL, conf.level = 0.95, beta_fun = fmt_beta,
  pvalue_fun = fmt_pvalue)
}
\arguments{
\item{data}{Data frame to be used in univariate regression modeling.  Data frame
includes the outcome variable(s) and the independent variables.}

\item{method}{Regression method (e.g. \code{\link[stats]{lm}}, \code{\link[stats]{glm}},
\code{\link[survival]{coxph}}, and more).}

\item{y}{model outcome as a string (e.g. \code{y = 'recurrence'} or \code{y = 'Surv(time, recur)'})}

\item{method.args}{List of additional arguments passed on to the regression function defined by method.}

\item{formula}{String that becomes the model formula.  Uses \code{\link[glue]{glue}} syntax.
Default is \code{"{y} ~ {.x}"}, where \code{{y}} is the dependent variable, and \code{{.x}}
represents a single covariate. For a random intercept, the formula may be
\code{formula = "{y} ~ {.x} + (1 | gear)"}.}

\item{exponentiate}{logical argument passed directly to \code{broom::tidy()}.
Default is \code{FALSE}}

\item{label}{list of labels to write in the output. \code{list(age60 = "Age > 60")}}

\item{show_yesno}{Vector of names of categorical and factor variables that
are \code{c("No", "Yes")}, \code{c("no", "yes")}, or \code{c("NO", "YES")} default to dichotomous printing
(i.e. only Yes shown). To force both levels to be shown include the column
name in \code{show_yesno}, e.g. \code{show_yesno = c("highgrade", "female")}}

\item{conf.level}{confidence level passed directly to \code{broom::tidy}.
Default is 0.95.}

\item{beta_fun}{function to round and format beta coefficients.  Default is \code{\link{fmt_beta}}}

\item{pvalue_fun}{function to round and format p-values.  Default is \code{\link{fmt_pvalue}}}
}
\description{
The \code{fmt_uni_regression} function arguments are similar to the \code{\link{fmt_regression}}
arguments. Review the \code{fmt_uni_regression} vignette for detailed examples.
}
\examples{
fmt_uni_regression(
  trial,
  method = "glm",
  y = "response",
  method.args = list(family = binomial),
  exponentiate = TRUE
)

# rounding pvalues to 2 decimal places, and adding global p-values
fmt_uni_regression(
  trial,
  method = "glm",
  y = "response",
  method.args = list(family = binomial),
  exponentiate = TRUE,
  pvalue_fun = function(x) fmt_pvalue(x, digits = 2)
) \%>\%
  add_global()
}
