% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent_key.R
\name{indent_key.fmt_regression}
\alias{indent_key.fmt_regression}
\title{Makes index of factor variables requiring indent from
\code{fmt_regression} objects in Rmarkdown}
\usage{
\method{indent_key}{fmt_regression}(x, ...)
}
\arguments{
\item{x}{\code{fmt_regression} object}

\item{...}{further arguments passed to or from other methods}
}
\description{
Makes index of factor variables requiring indent from
\code{fmt_regression} objects in Rmarkdown
}
\examples{
\donttest{
  library(lme4)
  mod_glmer <- glmer(am ~ hp + +wt + factor(cyl) + (1 | gear), mtcars, family = binomial)
  tglmer <- fmt_regression(mod_glmer, exponentiate = TRUE)

  # In RMarkdown, knitting to HTML:
  knitr::kable(as_tibble(tglmer),
    row.names = FALSE,
    caption = "Model Summary"
  ) \%>\%
    kableExtra::kable_styling(
      bootstrap_options = c("striped", "condensed"),
      font_size = 11,
      full_width = F
    ) \%>\%
    kableExtra::add_indent(indent_key(tglmer)) \%>\%
    kableExtra::footnote(general = "Model coefficients and p-values calculated using
  generalized linear mixed model, with random intercept specified
  as gear type.")
}

}
