% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_pvalue.R
\name{style_pvalue}
\alias{style_pvalue}
\title{Style p-values to be displayed in tables or text}
\usage{
style_pvalue(x, digits = 1, prepend_p = FALSE)
}
\arguments{
\item{x}{Numeric vector of p-values.}

\item{digits}{Number of digits large p-values are rounded. Must be 1 or 2.
Default is 1.}

\item{prepend_p}{Logical. Should 'p=' be prepended to formatted p-value.
Default is \code{FALSE}}
}
\value{
A character vector of styled p-values
}
\description{
Style p-values to be displayed in tables or text
}
\examples{
pvals <- c(
  1.5, 1, 0.999, 0.5, 0.25, 0.2, 0.197, 0.12, 0.10, 0.0999, 0.06,
  0.03, 0.002, 0.001, 0.00099, 0.0002, 0.00002, -1
)
style_pvalue(pvals)
style_pvalue(pvals, digits = 2, prepend_p = TRUE)
}
\seealso{
See tbl_summary \href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_summary.html}{vignette} for examples

Other style tools: 
\code{\link{style_percent}()},
\code{\link{style_ratio}()},
\code{\link{style_sigfig}()}
}
\author{
Daniel D. Sjoberg
}
\concept{style tools}
