% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_footnote.R
\name{modify_footnote}
\alias{modify_footnote}
\title{Update gtsummary table footnote}
\usage{
modify_footnote(x, update, abbreviation = FALSE)
}
\arguments{
\item{x}{a gtsummary object}

\item{update}{list of formulas or a single formula specifying the footnote
update. The LHS selects the columns from \code{x$table_body}
whose footnote will be updated, and the RHS is the new footnote. For example,
\code{update = stat_0 ~ "New footnote!"} or
\code{update = starts_with("stat_") ~ "New footnote!"}. To delete the footnote,
update the text to \code{NA}.}

\item{abbreviation}{Logical indicating if an abbreviation is being updated.
Abbreviation footnotes are handled differently. See examples below.}
}
\value{
gtsummary object
}
\description{
Update gtsummary table footnote
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{modify_footnote_ex1.png}{options: width=60\%}}

\if{html}{Example 2}

\if{html}{\figure{modify_footnote_ex2.png}{options: width=55\%}}

\if{html}{Example 3}

\if{html}{\figure{modify_footnote_ex3.png}{options: width=45\%}}
}

\examples{
tbl_summary <-
  trial \%>\%
  select(trt, age, grade) \%>\%
  tbl_summary(by = trt)

# Example 1 ----------------------------------
# update footnote
modify_footnote_ex1 <-
  tbl_summary \%>\%
  modify_footnote(
    update = starts_with("stat_") ~
      "median (IQR) for continuous variables; n (\%) categorical variables"
  )

# Example 2 ----------------------------------
# delete all footnotes - except abbreviations
# use `modify_footnote(everything() ~ NA, abbreviation = TRUE)` to delete abbrev. footnotes
modify_footnote_ex2 <-
  tbl_summary \%>\%
  modify_footnote(update = everything() ~ NA)

# Example 3 ----------------------------------
# updating the footnote abbreviation for CI
modify_footnote_ex3 <-
  glm(response ~ age + grade, trial, family = binomial) \%>\%
  tbl_regression(exponentiate = TRUE) \%>\%
  modify_footnote(ci ~ "CI = Credible Interval", abbreviation = TRUE)
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}

Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}

Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}
}
\concept{tbl_regression tools}
\concept{tbl_summary tools}
\concept{tbl_uvregression tools}
