% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nevent.R
\name{add_nevent.tbl_survfit}
\alias{add_nevent.tbl_survfit}
\title{Add column with number of observed events}
\usage{
\method{add_nevent}{tbl_survfit}(x, ...)
}
\arguments{
\item{x}{object of class 'tbl_survfit'}

\item{...}{Not used}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
For each \code{survfit()} object summarized with \code{tbl_survfit()} this function
will add the total number of events observed in a new column.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_nevent.tbl_survfit_ex1.png}{options: width=64\%}}
}

\examples{
library(survival)
fit1 <- survfit(Surv(ttdeath, death) ~ 1, trial)
fit2 <- survfit(Surv(ttdeath, death) ~ trt, trial)

# Example 1 ----------------------------------
add_nevent.tbl_survfit_ex1 <-
  list(fit1, fit2) \%>\%
  tbl_survfit(times = c(12, 24)) \%>\%
  add_n() \%>\%
  add_nevent()
}
\seealso{
Other tbl_survfit tools: 
\code{\link{add_n.tbl_survfit}()},
\code{\link{add_p.tbl_survfit}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_survfit}()}
}
\concept{tbl_survfit tools}
