% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_survfit.R
\name{tbl_survfit}
\alias{tbl_survfit}
\alias{tbl_survfit.survfit}
\alias{tbl_survfit.data.frame}
\alias{tbl_survfit.list}
\title{Creates table of survival probabilities}
\usage{
tbl_survfit(x, ...)

\method{tbl_survfit}{survfit}(
  x,
  times = NULL,
  probs = NULL,
  statistic = NULL,
  label = NULL,
  label_header = NULL,
  estimate_fun = NULL,
  missing = NULL,
  conf.level = 0.95,
  reverse = FALSE,
  quiet = NULL,
  failure = NULL,
  ...
)

\method{tbl_survfit}{data.frame}(
  x,
  y,
  times = NULL,
  probs = NULL,
  statistic = NULL,
  label = NULL,
  label_header = NULL,
  estimate_fun = NULL,
  missing = NULL,
  conf.level = 0.95,
  reverse = FALSE,
  failure = NULL,
  include = everything(),
  quiet = NULL,
  ...
)

\method{tbl_survfit}{list}(
  x,
  times = NULL,
  probs = NULL,
  statistic = NULL,
  label = NULL,
  label_header = NULL,
  estimate_fun = NULL,
  missing = NULL,
  conf.level = 0.95,
  reverse = FALSE,
  quiet = NULL,
  ...
)
}
\arguments{
\item{x}{a survfit object, list of survfit objects, or a data frame.
If a data frame is passed, a list of survfit objects is constructed using
each variable as a stratifying variable.}

\item{...}{Not used}

\item{times}{numeric vector of times for which to return survival probabilities.}

\item{probs}{numeric vector of probabilities with values in (0,1)
specifying the survival quantiles to return}

\item{statistic}{string defining the statistics to present in the table.
Default is \code{"{estimate} ({conf.low}, {conf.high})"}}

\item{label}{List of formulas specifying variables labels,
e.g. \code{list(age ~ "Age, yrs", stage ~ "Path T Stage")}, or a string for a
single variable table.}

\item{label_header}{string specifying column labels above statistics. Default
is \code{"{prob} Percentile"} for survival percentiles, and \code{"Time {time}"} for n-year
survival estimates}

\item{estimate_fun}{function to format the Kaplan-Meier estimates. Default
is \link{style_percent} for survival probabilities and \link{style_sigfig} for
survival times}

\item{missing}{text to fill when estimate is not estimable. Default is \code{"--"}}

\item{conf.level}{Confidence level for confidence intervals. Default is 0.95}

\item{reverse}{Flip the probability reported, i.e. \code{1 - estimate}.
Default is \code{FALSE}.  Does not apply to survival quantile requests}

\item{quiet}{Logical indicating whether to print messages in console. Default is
\code{FALSE}}

\item{failure}{DEPRECATED. Use \verb{reverse=} instead.}

\item{y}{outcome call, e.g. \code{y = Surv(ttdeath, death)}}

\item{include}{Variable to include as stratifying variables.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
Function takes a \code{survfit} object as an argument, and provides a
formatted summary table of the results
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_survfit_ex1.png}{options: width=55\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_survfit_ex2.png}{options: width=45\%}}

\if{html}{Example 3}

\if{html}{\figure{tbl_survfit_ex3.png}{options: width=55\%}}

\if{html}{Example 4}

\if{html}{\figure{survfit_cr_ex4.png}{options: width=55\%}}
}

\examples{
library(survival)

# Example 1 ----------------------------------
# Pass single survfit() object
tbl_survfit_ex1 <- tbl_survfit(
  survfit(Surv(ttdeath, death) ~ trt, trial),
  times = c(12, 24),
  label_header = "**{time} Month**"
)

# Example 2 ----------------------------------
# Pass a data frame
tbl_survfit_ex2 <- tbl_survfit(
  trial,
  y = survival::Surv(ttdeath, death),
  include = c(trt, grade),
  probs = 0.5,
  label_header = "**Median Survival**"
)

# Example 3 ----------------------------------
# Pass a list of survfit() objects
tbl_survfit_ex3 <-
  list(survfit(Surv(ttdeath, death) ~ 1, trial),
       survfit(Surv(ttdeath, death) ~ trt, trial)) \%>\%
  tbl_survfit(times = c(12, 24))

# Example 4 Competing Events Example ---------
# adding a competing event for death (cancer vs other causes)
library(dplyr, warn.conflicts = FALSE, quietly = TRUE)
trial2 <- trial \%>\%
  mutate(
  death_cr = case_when(
    death == 0 ~ "censor",
    runif(n()) < 0.5 ~ "death from cancer",
    TRUE ~ "death other causes"
  ) \%>\% factor()
)

survfit_cr_ex4 <-
  survfit(Surv(ttdeath, death_cr) ~ grade, data = trial2) \%>\%
  tbl_survfit(times = c(12, 24), label = "Tumor Grade")
}
\seealso{
Other tbl_survfit tools: 
\code{\link{add_n.tbl_survfit}()},
\code{\link{add_nevent.tbl_survfit}()},
\code{\link{add_p.tbl_survfit}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_survfit tools}
