% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_strata.R
\name{tbl_strata}
\alias{tbl_strata}
\title{Stratified gtsummary tables}
\usage{
tbl_strata(
  data,
  strata,
  .tbl_fun,
  ...,
  .sep = ", ",
  .combine_with = c("tbl_merge", "tbl_stack")
)
}
\arguments{
\item{data}{a data frame or survey object}

\item{strata}{character vector or tidy-selector of columns in data to stratify results by}

\item{.tbl_fun}{A function or formula. If a \emph{function}, it is used as is.
If a formula, e.g. \code{~ .x \%>\% tbl_summary() \%>\% add_p()}, it is converted to a function.
The stratified data frame is passed to this function.}

\item{...}{Additional arguments passed on to the \code{.tbl_fun} function.}

\item{.sep}{when more than one stratifying variable is passed, this string is
used to separate the levels in the spanning header. Default is \code{", "}}

\item{.combine_with}{One of \code{c("tbl_merge", "tbl_stack")}. Names the function
used to combine the stratified tables.}
}
\description{
\lifecycle{experimental}
Build a stratified gtsummary table. Any gtsummary table that accepts
a data frame as its first argument can be stratified.
}
\section{Tips}{

\itemize{
\item \code{tbl_summary()}
\itemize{
\item The number of digits continuous variables are rounded to is determined
separately within each stratum of the data frame. Set the \verb{digits=}
argument to ensure continuous variables are rounded to the same number
of decimal places.
\item If some levels of a categorical variable are unobserved within a
stratum, convert the variable to a factor to ensure all levels appear in
each stratum's summary table.
}
}
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_strata_ex1.png}{options: width=64\%}}
}

\examples{
# Example 1 ----------------------------------
tbl_strata_ex1 <-
  trial \%>\%
  select(age, grade, stage, trt) \%>\%
  mutate(grade = paste("Grade", grade)) \%>\%
  tbl_strata(
    strata = grade,
    .tbl_fun =
      ~ .x \%>\%
        tbl_summary(by = trt, missing = "no") \%>\%
        add_n()
  )
}
\author{
Daniel D. Sjoberg
}
