% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_percent.R
\name{style_percent}
\alias{style_percent}
\title{Style percentages}
\usage{
style_percent(
  x,
  symbol = FALSE,
  digits = 0,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  ...
)
}
\arguments{
\item{x}{numeric vector of percentages}

\item{symbol}{Logical indicator to include percent symbol in output.
Default is \code{FALSE}.}

\item{digits}{number of digits to round large percentages (i.e. greater than 10\%).
Smaller percentages are rounded to \code{digits + 1} places.
Default is \code{0}}

\item{big.mark}{(\code{string})\cr
Character used between every 3 digits to separate
hundreds/thousands/millions/etc.
Default is \code{","}, except when \code{decimal.mark = ","} when the default is a space.}

\item{decimal.mark}{(\code{string})\cr
The character to be used to indicate the numeric decimal point.
Default is \code{"."}  or \code{getOption("OutDec")}}

\item{...}{Arguments passed on to \code{base::format()}}
}
\value{
A character vector of styled percentages
}
\description{
Style percentages
}
\examples{
percent_vals <- c(-1, 0, 0.0001, 0.005, 0.01, 0.10, 0.45356, 0.99, 1.45)
style_percent(percent_vals)
style_percent(percent_vals, symbol = TRUE, digits = 1)
}
\author{
Daniel D. Sjoberg
}
